% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_annotation.R
\name{sample_annotation}
\alias{sample_annotation}
\title{Annotate the SWATH data with the sample information}
\usage{
sample_annotation(
  data,
  sample_annotation,
  data_type = "OpenSWATH",
  column_file = "filename",
  change_run_id = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{data}{A data frame containing SWATH data.}

\item{sample_annotation}{A data frame containing the columns: Filename,
Condition, BioReplicate, Run. The values contained in the column filename
have to be present in the filename of the SWATH data.}

\item{data_type}{Option to specify the format of the table, if the column
names from an OpenSWATH output or MSstats table are used.}

\item{column_file}{Option to specify the column name where the injection 
file is specified. Default is set to "filename".}

\item{change_run_id}{Option to choose if the run_id column shall be
reassigned to a unique value combining the values of Condition,
BioReplicate and Run. (Option only possible if data is of format
"OpenSWATH")}

\item{verbose}{Option to turn on reporting on which filename it is working
on.}
}
\value{
Returns a dataframe with each row annotated for the study design
}
\description{
For statistical analysis and filtering the measurements need to be annotated
with Filename, Condition, BioReplicate, and Run. This functions takes this
information from a txt file containing this meta-data.
}
\details{
Given dataframes of TRIC processed data and sample annotations, mash them
together into something appropriate for downstream analyses.

This performs some quick sanity checks on the data and annotations and
creates the 'Condition', 'BioReplicate', and 'Run' columns along with other
columns expected by MSstats/OpenSWATH.
}
\examples{
 data("OpenSWATH_data", package="SWATH2stats")
 data("Study_design", package="SWATH2stats")
 data <- SWATH2stats::sample_annotation(OpenSWATH_data, Study_design, verbose=TRUE)
 summary(data)
}
\author{
Peter Blattmann
}
