% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STATegRa_omicsPCA_plotting.R
\name{plotVAF}
\alias{plotVAF}
\alias{plotVAF,caClass-method}
\title{Plot VAF (Variance Explained For) from Component Analysis}
\usage{
plotVAF(object, mainTitle="")
}
\arguments{
\item{object}{\code{\link{caClass-class}} object containing component analysis results}

\item{mainTitle}{Plot title}
}
\value{
\code{ggplot} object
}
\description{
This function visualises the VAF results from component analysis. The input is a \code{\link{caClass-class}} object from \code{\link{omicsCompAnalysis}}. VAF cannot be calculated if mode "O2PLS" was used. The plots for modes "DISCOSCA" and "JIVE" are different since DISCO-SCA distinctive components have some VAF in the other block. This VAF can be interpreted as an error in the rotation.
}
\examples{
data("STATegRa_S3")
require(ggplot2)
B1 <- createOmicsExpressionSet(Data=Block1.PCA,pData=ed.PCA,
                               pDataDescr=c("classname"))
B2 <- createOmicsExpressionSet(Data=Block2.PCA,
                               pData=ed.PCA,pDataDescr=c("classname"))
# Omics components analysis
discoRes <- omicsCompAnalysis(Input=list(B1,B2),Names=c("expr","mirna"),
                              method="DISCOSCA",Rcommon=2,Rspecific=c(2,2),
                              center=TRUE,scale=TRUE,weight=TRUE)
jiveRes <- omicsCompAnalysis(Input=list(B1,B2),Names=c("expr","mirna"),
                             method="JIVE",Rcommon=2,Rspecific=c(2,2),
                             center=TRUE,scale=TRUE,weight=TRUE)

# DISCO-SCA plotVAF
plotVAF(discoRes)

# JIVE plotVAF
plotVAF(jiveRes)
}
\author{
Patricia Sebastian-Leon
}
