% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STATegRa_omicsPCA_plotting.R
\name{plotRes}
\alias{plotRes}
\alias{plotRes,caClass,numeric,character,character,logical-method}
\title{Plot component analysis results}
\usage{
plotRes(object, comps=c(1, 2), what, type, combined, block=NULL, 
               color=NULL, shape=NULL, labels=NULL, title=NULL, xlabel=NULL, ylabel=NULL, background=TRUE, 
               palette=NULL, pointSize=4, labelSize=NULL, 
               axisSize=NULL, titleSize=NULL, sizeValues = c(2,4), shapeValues = c(17, 0))
}
\arguments{
\item{object}{\code{\link{caClass-class}} containing component analysis results}

\item{comps}{If combined=FALSE, it indicates the x and y components of the type and block chosen. If \code{combined=TRUE}, it indicates the component to plot for the first block of information and the component for the second block of information to plot together. By default the components are set to c(1,2) if \code{combined=FALSE} and to c(1,1) if \code{combined=TRUE}.}

\item{what}{Either "scores", "loadings" or "both"}

\item{type}{Either "common", "individual" or "both"}

\item{combined}{Logical indicating whether to make a simple plot of two components from one block, or components from different blocks}

\item{block}{Which block to plot, either "1" or "2" or the name of the block.}

\item{color}{Character specifying a pData column from the original data to use to color points}

\item{shape}{Character specifying a pData column to select point shape}

\item{labels}{Character specifying a pData column from which to take point labels}

\item{title}{Main title}

\item{xlabel}{x-axis name}

\item{ylabel}{y-axis name}

\item{background}{Logical specifying whether to make a grey background}

\item{palette}{Vector giving the color palette for the plot}

\item{pointSize}{Size of plot points}

\item{labelSize}{Size of point labels if not NULL}

\item{axisSize}{Size of axis text}

\item{titleSize}{Size of title text}

\item{sizeValues}{Vector containing sizes for scores and loadings}

\item{shapeValues}{Vector indicating the shapes for scores and loadings}
}
\value{
\code{ggplot} object
}
\description{
Plot scatterplots of scores or loadings, for common and distinctive parts as well as combined plots.
}
\examples{
data("STATegRa_S3")
B1 <- createOmicsExpressionSet(Data=Block1.PCA,pData=ed.PCA,
                               pDataDescr=c("classname"))
B2 <- createOmicsExpressionSet(Data=Block2.PCA,
                               pData=ed.PCA,pDataDescr=c("classname"))
# Omics components analysis
discoRes <- omicsCompAnalysis(Input=list(B1,B2),Names=c("expr","mirna"),
                              method="DISCOSCA",Rcommon=2,Rspecific=c(2,2),
                              center=TRUE,scale=TRUE,weight=TRUE)
jiveRes <- omicsCompAnalysis(Input=list(B1,B2),Names=c("expr","mirna"),
                             method="JIVE",Rcommon=2,Rspecific=c(2,2),
                             center=TRUE,scale=TRUE,weight=TRUE)

o2plsRes <- omicsCompAnalysis(Input=list(B1,B2),Names=c("expr","mirna"),
                              method="O2PLS",Rcommon=2,Rspecific=c(2,2),
                              center=TRUE,scale=TRUE,weight=TRUE)

# Scatterplot of scores variables associated to common components

# DISCO-SCA
plotRes(object=discoRes,comps=c(1,2),what="scores",type="common",
        combined=FALSE,block=NULL,color="classname",shape=NULL,labels=NULL,
        background=TRUE,palette=NULL,pointSize=4,labelSize=NULL,
        axisSize=NULL,titleSize=NULL)
# JIVE
plotRes(object=jiveRes,comps=c(1,2),what="scores",type="common",
       combined=FALSE,block=NULL,color="classname",shape=NULL,labels=NULL,
        background=TRUE,palette=NULL,pointSize=4,labelSize=NULL,
        axisSize=NULL,titleSize=NULL)

# O2PLS
# Scatterplot of scores variables associated to common components
# Associated to first block
p1 <- plotRes(object=o2plsRes,comps=c(1,2),what="scores",type="common",
              combined=FALSE,block="expr",color="classname",shape=NULL,
              labels=NULL,background=TRUE,palette=NULL,pointSize=4,
              labelSize=NULL,axisSize=NULL,titleSize=NULL)
# Associated to second block
p2 <- plotRes(object=o2plsRes,comps=c(1,2),what="scores",type="common",
              combined=FALSE,block="mirna",color="classname",shape=NULL,
              labels=NULL,background=TRUE,palette=NULL,pointSize=4,
              labelSize=NULL,axisSize=NULL,titleSize=NULL)

# Combined plot of scores variables assocaited to common components
plotRes(object=o2plsRes,comps=c(1,1),what="scores",type="common",
        combined=TRUE,block=NULL,color="classname",shape=NULL,
        labels=NULL,background=TRUE,palette=NULL,pointSize=4,
        labelSize=NULL,axisSize=NULL,titleSize=NULL)

# Loadings plot for individual components
# Separately for each block
p1 <- plotRes(object=discoRes,comps=c(1,2),what="loadings",type="individual",
              combined=FALSE,block="expr",color="classname",shape=NULL,
              labels=NULL,background=TRUE,palette=NULL,pointSize=4,
              labelSize=NULL,axisSize=NULL,titleSize=NULL)
p2 <- plotRes(object=discoRes,comps=c(1,2),what="loadings",type="individual",
              combined=FALSE,block="mirna",color="classname",shape=NULL,
              labels=NULL,background=TRUE,palette=NULL,pointSize=4,
              labelSize=NULL,axisSize=NULL,titleSize=NULL)

# Biplot: scores + loadings
plotRes(object=discoRes,comps=c(1,2),what="both",type="common",
        combined=FALSE,block="expr",color="classname",shape=NULL,
        labels=NULL,background=TRUE,palette=NULL,pointSize=4,
        labelSize=NULL,axisSize=NULL,titleSize=NULL)
}
\author{
Patricia Sebastian-Leon
}
