% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STATegRa_omicsPCA_caClass.R
\name{getPreprocessing}
\alias{getPreprocessing}
\alias{getPreprocessing,caClass-method}
\title{Retrieve information about preprocessing}
\usage{
getPreprocessing(x, process=FALSE, preproData=FALSE, block=NULL)
}
\arguments{
\item{x}{\code{\link{caClass-class}} object.}

\item{process}{Logical indicating whether to return information about the processing done.}

\item{preproData}{Logical indicating whether to return the pre-processed data matrices.}

\item{block}{Character indicating the block of data to be returned. It can be specified by the position of the block ("1" or "2") or the name assigned in the \code{\link{caClass-class}} object. If it is NULL both blocks are displayed.}
}
\value{
If both \code{process} and \code{preproData} are specified, a list containing (otherwise the individual item):
\describe{
     \item{process}{Character indicating the processing done}
     \item{preproData}{Matrix (or list of matrices, depending on \code{block}) containing pre-processed data}
 }
}
\description{
Generic function to retrieve information about the preprocessing done by \code{\link{omicsCompAnalysis}} on a \code{\link{caClass-class}} object.
}
\examples{
data("STATegRa_S3")
B1 <- createOmicsExpressionSet(Data=Block1.PCA, pData=ed.PCA,
                               pDataDescr=c("classname"))
B2 <- createOmicsExpressionSet(Data=Block2.PCA,
                               pData=ed.PCA, pDataDescr=c("classname"))
# Omics components analysis
res <- omicsCompAnalysis(Input=list(B1, B2), Names=c("expr", "mirna"),
                         method="DISCOSCA", Rcommon=2, Rspecific=c(2, 2),
                         center=TRUE, scale=TRUE, weight=TRUE)
getPreprocessing(res, process=TRUE)
getPreprocessing(res, preproData=TRUE, block="1")
}
\seealso{
\code{\link{omicsCompAnalysis}}, \code{\link{caClass-class}}
}
\author{
Patricia Sebastian-Leon
}
