% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_benchmark.R
\name{sponge_run_benchmark}
\alias{sponge_run_benchmark}
\title{run sponge benchmark where various settings, i.e. with or without
regression, single or pooled miRNAs, are compared.}
\usage{
sponge_run_benchmark(
  gene_expr,
  mir_expr,
  mir_predicted_targets,
  number_of_samples = 100,
  number_of_datasets = 100,
  number_of_genes_to_test = c(25),
  compute_significance = FALSE,
  folder = NULL
)
}
\arguments{
\item{gene_expr}{A gene expression matrix with samples in rows and featurs
in columns. Alternatively an object of class ExpressionSet.}

\item{mir_expr}{A miRNA expression matrix with samples in rows and features
in columns. Alternatively an object of class ExpressionSet.}

\item{mir_predicted_targets}{(a list of) mir interaction sources such as
targetscan, etc.}

\item{number_of_samples}{number of samples in the null model}

\item{number_of_datasets}{number of datasets to sample from the null model}

\item{number_of_genes_to_test}{a vector of numbers of genes to be tested,
e.g. c(250,500)}

\item{compute_significance}{whether to compute p-values}

\item{folder}{where the results should be saved, if NULL no output to disk}
}
\value{
a list (regression, no regression) of lists (single miRNA,
pooled miRNAs) of benchmark results
}
\description{
run sponge benchmark where various settings, i.e. with or without
regression, single or pooled miRNAs, are compared.
}
\examples{
sponge_run_benchmark(gene_expr = gene_expr, mir_expr = mir_expr,
mir_predicted_targets = targetscan_symbol,
number_of_genes_to_test = c(10), folder = NULL)
}
