% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_spongeffects_utility.R
\name{fn_weighted_degree}
\alias{fn_weighted_degree}
\title{Function to calculate centrality scores
Calculation of weighted degree scores based on Opsahl et al. (2010)
Hyperparameter to tune: Alpha = 0 --> degree centrality as defined in
Freeman, 1978 (number of edges).}
\usage{
fn_weighted_degree(network, undirected = T, Alpha = 1)
}
\arguments{
\item{network}{Network formatted as a dataframe with three columns containing
respectively node1, node2 and weights}

\item{undirected}{directionality of the network (default: T)}

\item{Alpha}{degree centrality as defined in Barrat et al., 2004 (default: 1)}
}
\value{
Dataframe containing information about nodes and their weighted
centrality measure
}
\description{
Function to calculate centrality scores
Calculation of weighted degree scores based on Opsahl et al. (2010)
Hyperparameter to tune: Alpha = 0 --> degree centrality as defined in
Freeman, 1978 (number of edges).
}
