\name{tabulate.top.dep.features}

\alias{tabulate.top.dep.features}

\title{Lists the P-values for the dependent features}

\description{
	Lists the integrated analysis P-values for the dependent features in the analyzed regions, 
together with the available annotation.
}

\usage{
tabulate.top.dep.features(input.regions = "all chrs", 
                          adjust.method="BY", 
                          method = c("full", "smooth", "window", "overlap"), 
                          significance = 1, 
                          run.name = "analysis_results")
} 

\arguments{
	\item{input.regions}{\code{vector} indicating the dependent regions to be analyzed. Can be defined in four ways:
  	      \code{1) predefined input region: } insert a predefined input region, choices are: 
  	      \dQuote{all chrs}, 
  	      \dQuote{all chrs auto}, 
  	      \dQuote{all arms}, 
  	      \dQuote{all arms auto} 
  	      In the predefined regions \dQuote{all arms} and \dQuote{all arms auto} the arms 13p, 14p, 15p, 21p and 22p 
  	      are left out, because in most studies there are no or few probes in these regions. 
  	      To include them, just make your own vector of arms. 
  	      \code{2) whole chromosome(s): } insert a single chromosome or a list of chromosomes as a 
  	      \code{vector:} 
  	      \code{c(1, 2, 3)}. 
  	      \code{3) chromosome arms: } insert a single chromosome arm  or a list of chromosome arms like 
  	      \code{c("1q", "2p", "2q")}.
  	      \code{4) subregions of a chromosome: } insert a chromosome number followed by the start and end position like 
  	      \code{"chr1:1-1000000"} 
  	      These regions can also be combined, e.g. \code{c("chr1:1-1000000","2q", 3)}.
  	      See \code{\link{integrated.analysis}} for more information.} 

	\item{adjust.method}{Method used to adjust the P-values for multiple testing, see \link[stats:p.adjust]{p.adjust}.
         Default is \dQuote{BY} recommended when copy number is used as dependent data. 
         See \link{SIM} for more information about adjusting P-values.}

	\item{method}{this must be the either one of \dQuote{full}, \dQuote{window}, \dQuote{overlap} or \dQuote{smooth} but the data should generated by the 
         same method in \code{integrated.analysis}.}

	\item{significance}{threshold used to select the significant dependent
   features. Pvalues below this threshold will be used to estimate regions.}
 
	\item{run.name}{This must be the same a given to \code{integrated.analysis}}
}

\details{
	Output is a .txt file containing a table with sorted integrated analysis P-values of the 
dependent features. It includes the \code{ann.dep} columns that were read in the \link{assemble.data} function.
Additionally it returns a .txt file containing the significant P-value rich regions. No P-value rich regions are returned when \code{zscores.diag = "all"}.
}

\value{
	Returns a \code{list} of \code{data.frame}'s for each input region.
Significant P-value rich regions are returned as a \code{data.frame}. 
This data.frame can be used as an input for \link{getoverlappingregions}. 
Additionally, the results are stored in a subdirectory of \code{run.name} as txt.
}

\author{Marten Boetzer, Melle Sieswerda, Renee X. de Menezes  \email{R.X.Menezes@lumc.nl}}

\seealso{
\link{SIM}, 
\link{tabulate.pvals}, 
\link{tabulate.top.indep.features}
}

\examples{
#first run example(assemble.data)
#and example(integrated.analysis)
#get the top dependent features sorted by p-value
table.dep <- tabulate.top.dep.features(input.regions="8q", 
		                  adjust.method="BY", 
						  method="full",
						  significance=0.05,
						  run.name="chr8q")
head(table.dep[["8q"]])						  
}
\keyword{misc}

