% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIMLR_Estimate_Number_of_Clusters.R
\name{SIMLR_Estimate_Number_of_Clusters}
\alias{SIMLR_Estimate_Number_of_Clusters}
\title{SIMLR Estimate Number of Clusters}
\usage{
SIMLR_Estimate_Number_of_Clusters(X, NUMC = 2:5, cores.ratio = 1)
}
\arguments{
\item{X}{an (m x n) data matrix of gene expression measurements of individual cells}

\item{NUMC}{vector of number of clusters to be considered}

\item{cores.ratio}{ratio of the number of cores to be used when computing the multi-kernel}
}
\value{
a list of 2 elements: K1 and K2 with an estimation of the best clusters (the lower 
values the better) as discussed in the original paper of SIMLR
}
\description{
estimate the number of clusters by means of two huristics as discussed in the SIMLR paper
}
\examples{
data(BuettnerFlorian)
SIMLR_Estimate_Number_of_Clusters(BuettnerFlorian$in_X,
   NUMC = 2:5,
   cores.ratio = 0)

}
