%% getRI function %%
\name{getRI}
\alias{getRI}

\title{Generate a calibration function}

\description{This function generates a calibration function which can be used to calculate the retention index of a compound, given its retention time together with the retention indexes of RI standards and their retention times.}

\usage{
getRI(RItable = data.frame())
}

%- maybe also 'usage' for other objects documented here.
\arguments{
    \item{RItable}{a data frame of retention times and indexes of RI standardsPeaks, e.g. generated by calling \code{getRIStandard}.}
}

\details{The input of this function is an RItable. RItable is the table of RTs and correponding RIs of RI standards measured using an RI run. The user can get the RItable using the \code{getRIStandard} function. The output of this function is a function which can be used for retention index calculation providing a retention time. It also enables the user to estimate the retention time of a provided retention index.
}

\value{
A calibration function which accepts a retention time and outputs corresponding retention index. The user can also provide a retention index and estimate the related retention time based on RI calibration.
}

\seealso{\code{\link{getRIStandard}}}

\references{\url{http://omics.georgetown.edu/SIMAT.html}}

\author{Mo Nezami Ranjbar}

%\note{  No notes for this function either }

\examples{
    # load retention index table from RI standards
    data(RItable)

    # create a calibration function
    calibRI <- getRI(RItable)
    
    # perform RI calibration for a certain RT = 12.32min
    calibRI(12.32)
    
    # estimate the RT of an RI based RI calibration
    calibRI(ri = 1150)
}