% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_predictions.r
\encoding{UTF-8}
\name{make.predictions}
\alias{make.predictions}
\title{Make predictions on a test set}
\usage{
make.predictions(siamcat, siamcat.holdout = NULL, 
normalize.holdout = TRUE, verbose = 1)
}
\arguments{
\item{siamcat}{object of class \link{siamcat-class}}

\item{siamcat.holdout}{optional, object of class \link{siamcat-class} on 
which to make predictions, defaults to \code{NULL}}

\item{normalize.holdout}{boolean, should the holdout features be normalized
with a frozen normalization (see \link{normalize.features}) using the
normalization parameters in \code{siamcat}?, defaults to \code{TRUE}}

\item{verbose}{integer, control output: \code{0} for no output at all,
\code{1} for only information about progress and success, \code{2} for
normal level of information and \code{3} for full debug information,
defaults to \code{1}}
}
\value{
object of class \link{siamcat-class} with the slot 
\code{pred_matrix} filled
}
\description{
This function takes a \link{siamcat-class}-object containing
a model trained by \link{train.model} and performs predictions on 
a given test-set.
}
\details{
This functions uses the model in the \code{model_list}-slot of the
\code{siamcat} object to make predictions on a given test set. The test set 
can either consist of the test instances in the cross-validation, saved in 
the \code{data_split}-slot of the same \code{siamcat} object, or a 
completely external feature set, given in the form of another 
\code{siamcat} object (\code{siamcat.holdout}).
}
\examples{
data(siamcat_example)

# Simple example
siamcat_example <- train.model(siamcat_example, method='lasso')
siamcat.pred <- make.predictions(siamcat_example)

# Predictions on a holdout-set (not run)
# pred.mat <- make.predictions(siamcat.trained, siamcat.holdout,
#     normalize.holdout=TRUE)
}
\keyword{SIAMCAT}
\keyword{make.predictions}
