% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\name{setaPercent}
\alias{setaPercent}
\title{Percentage Transform
Converts each row (sample) of a counts matrix to percentages of its row sum.}
\usage{
setaPercent(counts)
}
\arguments{
\item{counts}{A numeric matrix with rows as samples and columns as taxa.}
}
\value{
A list with:
\describe{
  \item{method}{The string \code{"percent"}.}
  \item{counts}{A matrix of the same dimensions as
                \code{counts}, where each row sums to 100.}
}
}
\description{
Percentage Transform
Converts each row (sample) of a counts matrix to percentages of its row sum.
}
\details{
Useful for simplified comparisons and as an input to non-parametric tests.
}
\examples{
mat <- matrix(c(1,2,4,8), nrow = 2, byrow = TRUE)
out <- setaPercent(mat)
out$counts
}
