\name{SCANVISscan}
\alias{SCANVISscan}
\title{SCore and ANnotate splice junctions}
\description{
This function annotates and scores splice junctions (SJs) supplied in bed format (coordinates plus read support) and
gene annotations (see SCANVISannotation). Each SJ will get annotated by gene name and junction type, 
with unannotated SJs (USJs) falling into one of the following groups: exon.skip, alt3p, alt5p, IsoSwitch, Unknown and NE (Novel Exons) - see below. USJs are also checked and marked for in or out of frame shifts. Each SJ is scored by a Relative Read Support (RRS) score defined as the ratio of the junction read supportto the median read support of annotated SJs within a RRS genomic region, that being defined as the minimum interval that contains at least one gene overlapping the SJ and at least one annotated SJ overlapping the gene/s wtihin the interval. Novel Exons (NEs) are defined by USJ pairs that coincide in annotated intronic regions and are scored by the mean RRS of the supporting USJs and by a Relative Read Coverage (RRC) score when the bam file is supplied.}

\usage{SCANVISscan(sj, gen, Rcut = 5, bam = NULL, samtools = NULL)}
\arguments{
  \item{sj}{SJ matrix with colnames chr,start,end,uniq.reads}
  \item{gen}{gencode object as generated by SCANVISannotation}
  \item{Rcut}{min read cutoff; only SJs with >=Rcut reads are retained (Default=5)}
  \item{bam}{url to bam file for NE RRC computation (default=NULL)}
  \item{samtools}{url to samtools function, MUST be specified if bam is supplied (default=NULL)}
}
%\details{First run SCANVISannotation.R to assemble gencode data in SCANVISformat for use with this function (human gencode19 provided).}

\value{
An extension of the input SJ matrix for relevant SJs, with additional rows for NE junction pairs, as well as the following additional columns: 
\item{JuncType}{describes junction type as annot for annotated SJs and one of the following 
for unannotated SJs: exon.skip, alt3p, alt5p, IsoSwitch, Unknown and NE (Novel Exons) where exon.skip refers to SJs that skip an exon
present in all isoforms, alt3p refers to an alternative 3 prime acceptor site, alt5p refers to an alternative 5 prime donor sites, IsoSwitch refers to SJs aligning to mutually exclusive isoforms such that a novel unannotated isoform is incurred, Unknown SJs have coordinates that do not align to any exons and NE (Novel Exons) refers to SJ pairs with the start of one SJ and the end coordinate of the other SJ coinciding in an intronic region}
\item{gene_name}{genes that intersect with the SJ (multiple genes are comma separated}
\item{RRS}{Relative Read Support score defined as x/(x+y) where x is the query junction read support and y is the median read support of annotated SJs in the RRS genomic_interval}
\item{genomic_interval}{interval used for the RRS computation}
\item{FrameStatus}{frame shifts induced by unannotated SJs, where INframe 
indicates no frame-shift in any gene isoforms, OUTframe indicates frame-shifting in ALL gene isoforms
and all other entries indicating frame shifts for specified isoforms. FrameStatus is marked NA for annotated SJs)}
\item{RRC}{Relative Read Coverage score generated for NEs only, and computed only if the bam file is supplied}
}
%\references{
%% ~put references to the literature/web site here ~
%}
%\author{Phaedra Agius <pagius@nygenome.org>}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{SCANVISannotation, SCANVISlinkvar, SCANVISvisual}

\examples{
data(SCANVISexamples)
head(gbm3) #required SJ format
gbm3.scn<-SCANVISscan(sj=gbm3,gen=gen19,Rcut=5)
head(gbm3.scn)
### to compute RRC scores for NEs, run as follows:
#gbm3.scn<-SCANVISscan(gbm3,gen19,5,bam=<BAM>,samtools=<SAMTOOLS>)
}
\keyword{frameshift}
\keyword{RRS}
\keyword{RRC}
\keyword{bam}

