% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotMethods.R
\docType{methods}
\name{sc3_plot_markers}
\alias{sc3_plot_markers}
\alias{sc3_plot_markers.SingleCellExperiment}
\alias{sc3_plot_markers,}
\alias{sc3_plot_markers,SingleCellExperiment-method}
\alias{sc3_plot_markers,SingleCellExperiment-method}
\alias{sc3_plot_markers}
\title{Plot expression of marker genes identified by \code{SC3} as a heatmap.}
\usage{
sc3_plot_markers.SingleCellExperiment(object, k, auroc, p.val, show_pdata)

\S4method{sc3_plot_markers}{SingleCellExperiment}(object, k, auroc = 0.85,
  p.val = 0.01, show_pdata = NULL)
}
\arguments{
\item{object}{an object of 'SingleCellExperiment' class}

\item{k}{number of clusters}

\item{auroc}{area under the ROC curve}

\item{p.val}{significance threshold used for the DE genes}

\item{show_pdata}{a vector of colnames of the pData(object) table. Default is NULL.
If not NULL will add pData annotations to the columns of the output matrix}
}
\description{
By default the genes with the area under the ROC curve (AUROC) > 0.85 
and with the p-value < 0.01 are selected and the top 10 marker 
genes of each cluster are visualized in this heatmap.
}
