% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialMethylation.R
\name{rowPairedTP}
\alias{rowPairedTP}
\title{rowPairedTP}
\usage{
rowPairedTP(X, inds.g1, inds.g2 = -inds.g1, alternative = "two.sided")
}
\arguments{
\item{X}{Matrix on which the test is performed for every row}

\item{inds.g1}{column indices of group 1 members. \code{length(inds.g1)==length(inds.g2)} has to hold true.}

\item{inds.g2}{column indices of group 2 members. \code{length(inds.g1)==length(inds.g2)} has to hold true.}

\item{alternative}{Testing alternative. Must be one of "two.sided" (default),"less","greater" or "all".
in case of "all" a data frome with corresping alternative variables is returned. 
Otherwise the result is a vector.}
}
\value{
vector (or data.frame if alternative=="all") of p-values from a paired t-test
}
\description{
performs a two-sided t-test for paired samples on each row of a matrix X with the indices inds.1 vs indices inds.g2 as group assignments.
}
\note{
Requires \code{matrixStats} package
}
\author{
Fabian Mueller
}
