% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{rnb.execute.clustering}
\alias{rnb.execute.clustering}
\title{rnb.execute.clustering}
\usage{
rnb.execute.clustering(rnb.set, region.type = "sites")
}
\arguments{
\item{rnb.set}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBSet}}.}

\item{region.type}{the clustering is performed on methylation levels from regions of that type. 
see \code{\link{rnb.region.types}} for possible values.}
}
\value{
List of clustering results, whereby each element is an object of type \code{\linkS4class{RnBeadClustering}}.
        In case clustering cannot be performed, the return value is \code{NULL}. Reasons for a failure include, among
        others, the case when \code{rnb.set} contains less than 3 samples, or undefined distances between a pair of
        samples due to (too many) missing values in the respective methylation matrix.
}
\description{
Performs hierarchical clustering on the samples of the given dataset using multiple distance metrics and
agglomeration methods for a single given region type.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
results <- rnb.execute.clustering(rnb.set.example, "promoters")
# List applied dissimilarity metrics
sapply(results, slot, "dissimilarity")
# List applied clustering algorithms
str(lapply(results, slot, "algorithm"))
}
}
\author{
Yassen Assenov
}
