% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch.quality.R
\name{rnb.execute.batch.qc}
\alias{rnb.execute.batch.qc}
\title{rnb.execute.batch.qc}
\usage{
rnb.execute.batch.qc(rnb.set, pcoordinates, permutations = NULL)
}
\arguments{
\item{rnb.set}{HumanMethylation450K dataset as an object of type \code{\linkS4class{RnBeadSet}}.}

\item{pcoordinates}{Coordinates of the samples of \code{rnb.set} in the principal components space, as returned by
\code{\link{rnb.execute.dreduction}}.}

\item{permutations}{Matrix of sample index permutations, as returned by \code{\link{rnb.execute.batcheffects}}. If
this parameter is \code{NULL}, permutation-based p-values are not calculated.}
}
\value{
\code{NULL} if no principal components for batch analysis are specified (
        \code{rnb.getOption("exploratory.principal.components") == 0}); otherwise, a hierarchical structure of
        matrices in the form of a nested list. The root branches are represented by the elements
        \code{"correlations"} and \code{"pvalues"}. Every element is a list of control probe types; each type is in
        turn a list of up to two matrices of correlations between probe values and principal components - one for the
        probes on the green channel and one for the red channel. Note that the \code{"pvalues"} branch is not
        returned when \code{permutations} is \code{NULL}.
}
\description{
Computation of correlations and permutation-based p-values for detecting quality-associated batch effects.
}
\author{
Pavlo Lutsik
}
