% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Report-methods.R
\name{rnb.add.reference}
\alias{rnb.add.reference}
\title{rnb.add.reference}
\usage{
rnb.add.reference(report, txt)
}
\arguments{
\item{report}{Report to add a reference item to.}

\item{txt}{Text of the reference in the form of a non-empty \code{character} vector. The elements of this vector
are concatenated without a separator.}
}
\value{
The modified report.
}
\description{
Adds a reference item to the given report.
}
\examples{
\donttest{
report <- createReport("example.html", "Example", init.configuration = TRUE)
txt.reference <- c("Bird A. ", "<i>Nucleic Acids Res.</i> <b>8</b> (1980)")
report <- rnb.add.reference(report, txt.reference)
txt <- c("This was shown in ", rnb.get.reference(report, txt.reference), ".")
rnb.add.paragraph(report, txt)
}
}
\seealso{
\code{\link{rnb.get.reference}} for adding citations in the report's text; \code{\linkS4class{Report}} for
  other functions adding contents to an HTML report
}
\author{
Yassen Assenov
}
