% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterArchitectureLSF.R
\docType{methods}
\name{getSubCmdTokens,ClusterArchitectureLSF-method}
\alias{getSubCmdTokens,ClusterArchitectureLSF-method}
\title{getSubCmdTokens-methods}
\usage{
\S4method{getSubCmdTokens}{ClusterArchitectureLSF}(
  object,
  cmd.tokens,
  log,
  job.name = "",
  res.req = character(0),
  depend.jobs = character(0)
)
}
\arguments{
\item{object}{\code{\linkS4class{ClusterArchitectureLSF}} object}

\item{cmd.tokens}{a character vector specifying the executable command that should be wrapped in the cluster submission command}

\item{log}{file name and path of the log file that the submitted job writes to}

\item{job.name}{name of the submitted job}

\item{res.req}{named vector of requested resources. Two options are available: \code{"clock.limit"} and \code{"memory.size"}}

\item{depend.jobs}{character vector containg names or ids of jobs the submitted job will depend on.}
}
\value{
A character vector containing the submission command tokens
}
\description{
Returns a string for the of command line corresponding to submitting
a job with the given command to the cluster.
}
\details{
For a concrete child class implementation for a LSF architecture specification see \code{\linkS4class{ClusterArchitectureLSF}}
}
\examples{
\donttest{
arch <- new("ClusterArchitectureLSF",
	name="my_lsf_architecture"
)
getSubCmdTokens(arch,c("Rscript","my_great_script.R"),"my_logfile.log")
}
}
\author{
Michael Scherer
}
