\name{assessment-class}
\docType{class}
\alias{assessment-class}
\alias{getClassifierName,assessment-method}
\alias{getClassifierName<-,assessment-method}
\alias{getClassifierName}
\alias{getClassifierName<-}
\alias{getFeatureSelectionMethod,assessment-method}
\alias{getNoFolds1stLayer,assessment-method}
\alias{getNoFolds1stLayer<-,assessment-method}
\alias{getNoFolds1stLayer}
\alias{getNoFolds1stLayer<-}
\alias{getNoFolds2ndLayer,assessment-method}
\alias{getNoFolds2ndLayer<-,assessment-method}
\alias{getNoFolds2ndLayer}
\alias{getNoFolds2ndLayer<-}
\alias{getNoOfRepeats,assessment-method}
\alias{getNoOfRepeats<-,assessment-method}
\alias{getNoOfRepeats}
\alias{getNoOfRepeats<-}
\alias{getResult1LayerCV,assessment-method}
\alias{getResult1LayerCV<-,assessment-method}
\alias{getResult1LayerCV}
\alias{getResult1LayerCV<-}
\alias{getResult2LayerCV,assessment-method}
\alias{getResult2LayerCV<-,assessment-method}
\alias{getResult2LayerCV}
\alias{getResult2LayerCV<-}
\alias{getSvmKernel,assessment-method}
\alias{getSvmKernel<-,assessment-method}
\alias{getSvmKernel}
\alias{getSvmKernel<-}
\alias{getTypeFoldCreation,assessment-method}
\alias{getTypeFoldCreation<-,assessment-method}
\alias{getTypeFoldCreation}
\alias{getTypeFoldCreation<-}

\title{assessment: A central class to perform one and two layers of external cross-validation on microarray data}
\description{This class stores the information relevant to a microarray
    classification assessment: data set, classifier and options are set
    here and then one-layer and two-layer cross-validation can be applied. }
\section{Creating objects}{
    \code{new("assessment", dataset noFolds1stLayer=10, noFolds2ndLayer=9,
                classifierName="svm", featureSelectionMethod="rfe",
                typeFoldCreation="original", svmKernel="linear",
                noOfRepeat=2, featureSelectionOptions)}

Creates an assessment to be performed on the data set \code{dataset} using the feature
selection options defined by \code{featureSelectionMethod} on the feature selection method
\code{featureSelectionMethod} and with the classifier \code{classifierName}. Once
all the options have been selected one-layer and two-layers of cross-validation can be
performed by calling \code{runOneLayerExtCv} and \code{runTwoLayerExtCv} respectively.

 \code{new("assessment", dataset noFolds1stLayer=10, noFolds2ndLayer=9,
                classifierName="svm", featureSelectionMethod="rfe",
                typeFoldCreation="original", svmKernel="linear",
                noOfRepeat=2)}

If \code{featureSelectionOptions} is not precised in the arguments then the options for
the feature selection method are determined according to the \code{dataset} and
the \code{featureSelectionMethod}. If RFE is selected as feature selection method
then an object of class geneSubsets is automatically created. It defines sizes of
subsets og genes for 1 to the number of features in the \code{dataset} by power of 2.
If the feature selection method is NSC then the thresholds are taken to be the default
thresholds generated by the function \code{pamr.train} from package \code{pamr}
applied on \code{dataset}.
}
\section{Slots}{
	 \describe{
    \item{\code{dataset}:}{Object of class \code{"dataset"}. Microarray data set to be used for cross-validation}
    \item{\code{noFolds1stLayer}:}{\code{numeric}. Number of folds in the inner layee layer of cross-validation}
    \item{\code{noFolds2ndLayer}:}{\code{numeric}. Number of folds in one-layer cross-validation and in the
    second layer of cross-validation}
    \item{\code{classifierName}:}{\code{character}. Name of the classifier: 'svm' for Support Vector
    Machines or 'nsc' for Nearest Shrunken Centroid}
    \item{\code{featureSelectionMethod}:}{Object of class \code{"character"} ~~ }
    \item{\code{typeFoldCreation}:}{\code{character}. Type of fold creation: 'original', 'simple' or 'naive'}
    \item{\code{svmKernel}:}{Object of class \code{"character"} ~~ }
    \item{\code{noOfRepeats}:}{\code{numeric}. Number of repeats to be performed for each cross-validation.}
    \item{\code{featureSelectionOptions}:}{Object of class \code{"featureSelectionOptions"}. Sizes of subsets
    to be tried in the RFE or thresholds to be tried with the NSC.}
    \item{\code{resultRepeated1LayerCV}:}{Object of class \code{"resultRepeated1LayerCVOrNULL"} NULL is the external one layer CV has not been run yet, resultRepeated1LayerCV containing the results}
    \item{\code{resultRepeated2LayerCV}:}{Object of class \code{"result2LayerCVorNULL"} NULL is the external one layer CV has not been run yet, result2LayerCV containing the results }
    \item{\code{finalClassifier}:}{Object of class \code{"finalClassifierOrNULL"} NULL is the final classifier has not been determined yet, finalClassifier containing the final Classifier for each feature selection option. }
  }
}
\section{Methods}{
  \describe{
    \item{\code{classifyNewSamples(assessment)}}{Classify new samples using the final
    classifier. See related documentation.}
    \item{\code{findFinalClassifier(assessment)}}{Train the final classifier related
    to an assessment based on each feature selection option. See related documentation}
    \item{\code{getClassifierName(assessment), getClassifierName(assessment)<-}}{Retrieve
    and Modify the classifier name  associated to the current assessment (slot classifierName) }
    \item{\code{getDataset(assessment), getDataset(assessment)<-}}{Retrieve
    and Modify the dataset associated to the current assessment (slot dataset),
    see related documentation for more details.}
    \item{\code{getFeatureSelectionOptions(assessment), getFeatureSelectionOptions(assessment)<-}}{Retrieve
    and Modify the options of feature selection associated to the current assessment (slot featureSelectionOptions) }
    \item{\code{getFinalClassifier(assessment)}}{Retreive the final classifier associated with
    an exeperiment.}
    \item{\code{getNoFolds1stLayer(assessment), getNoFolds1stLayer(assessment)<-}}{Retrieve
    and Modify the number of folds in the inner layer of cross-validation (slot nbFolds1stLayer) }
    \item{\code{getNoFolds2ndLayer(assessment), getNoFolds2ndLayer(assessment)<-}}{Retrieve
    and Modify the number of folds in the outer layer of cross-validation (slot nbFolds1stLayer) }
    \item{\code{getNoOfRepeats(assessment), getNoOfRepeats(assessment)<-}}{Retrieve
    and Modify the number of repeats of each cross-validation (slot nbOfRepeat) }
    \item{\code{getResult1LayerCV(assessment)}}{Retrieve the results of the one-layer
    cross validation (slot resultRepeated1LayerCV). An easier access to this data is
    available via the method \code{getResults} ) }
    \item{\code{getResult2LayerCV(assessment)}}{Retrieve the results of the two-layers
    cross validation (slot result2LayerCV). An easier access to this data is
    available via the method \code{getResults}}
    \item{getResults}{User-friendly methods to retreive data in the
    results of one-layer and two-layers of cross-validation. See related documentation
    page.}
    \item{\code{getSvmKernel(assessment), getSvmKernel(assessment)<-}}{Retrieve
    and Modify the svm kernel used as a final classifier if svm is the concerned
    classifier and during the Recusrsive Feature Elimination (slot svmKernel) }
    \item{\code{getTypeFoldCreation(assessment), getTypeFoldCreation(assessment)<-}}{Retrieve
    and Modify the type of folds creation to use for each cross-validation
    (slot typeFoldCreation) }
    \item{\code{runOneLayerExtCV}}{Run one-layer cross-validation,
    see related documantation for more details.}
    \item{\code{runTwoLayerExtCV}}{Run two-layer cross-validation,
    see related documantation for more details.}
	 }
}

\author{ Camille Maumet }


\seealso{
    \code{\linkS4class{geneSubsets}}, \code{\link{getResults-methods}},
    \code{\link{runOneLayerExtCV-methods}}, \code{\link{runTwoLayerExtCV-methods}}
}
\examples{
#dataPath <- file.path("C:", "Documents and Settings", "c.maumet", "My Documents", "Programmation", "data")
#myDataset <- new("dataset", dataId="vantVeer_70", dataPath=file.path(dataPath, "vantVeer_70"))
# myDataset<-loadData(myDataset)

data('vV70genesDataset')

# assessment with RFE and SVM
myExpe <- new("assessment", dataset=vV70genes,
                   noFolds1stLayer=10,
                   noFolds2ndLayer=9,
                   classifierName="svm",
                   typeFoldCreation="original",
                   svmKernel="linear",
                   noOfRepeat=2,
                   featureSelectionOptions=new("geneSubsets", optionValues=c(1,2,3,4,5,6)))

# Another assessment where the subsets are computed automatically
anotherExpe <- new("assessment",    dataset=vV70genes,
                                   noFolds1stLayer=10,
                                   noFolds2ndLayer=9,
                                   classifierName="svm",
                                   typeFoldCreation="original",
                                   svmKernel="linear",
                                   noOfRepeat=2)
getFeatureSelectionOptions(anotherExpe, topic='maxSubsetSize')
getFeatureSelectionOptions(anotherExpe, topic='subsetsSizes')

# assessment with NSC
expeWithNSC <- new("assessment",dataset=vV70genes,
                               noFolds1stLayer=10,
                               noFolds2ndLayer=9,
                               classifierName="nsc",
                               featureSelectionMethod='nsc',
                               typeFoldCreation="original",
                               svmKernel="linear",
                               noOfRepeat=2)
getFeatureSelectionOptions(expeWithNSC, topic='thresholds')
}
\keyword{classes}
