% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readsToStartOrEnd.R
\name{readsToStartOrEnd}
\alias{readsToStartOrEnd}
\title{Reads in GAlignments converted to either Read Start (5') or End (3') Positions}
\usage{
readsToStartOrEnd(aln, what)
}
\arguments{
\item{aln}{A GAlignments object of the BAM mapping file.}

\item{what}{A character object. Either "start" (the default) or "end"
for read start or read end.}
}
\value{
A GRanges object containing either the read start or end
genomic positions.
}
\description{
Reads in GAlignments converted to either Read Start (5') or End (3') Positions
}
\examples{
#read the BAM file into a GAlignments object using
#GenomicAlignments::readGAlignments
#the GAlignments object should be similar to ctrlGAlignments object
data(ctrlGAlignments)
aln <- ctrlGAlignments
#transform the GAlignments object into a GRanges object (faster processing)
alnGRanges <- readsToStartOrEnd(aln, what = "end")
}

