% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codonPCA.R
\name{codonPCA}
\alias{codonPCA}
\title{PCA graphs on codon coverage}
\usage{
codonPCA(data, typeData)
}
\arguments{
\item{data}{a list of 2 data.frames:
one with the number of times each codon type is found in each ORF and
one with the number of reads for each codon in each ORF.}

\item{typeData}{a character string. It is used as title for the PCA.
Ex. typeData="codonCoverage"}
}
\value{
a list of length 2:
PCA_scores - matrix of the scores on the first 4 principal components.
PCA_plots - a list of 5 PCA scatterplots.
}
\description{
PCA graphs on codon coverage
}
\examples{
#How to perform a PCA analysis based on codon coverage
#adapted from
#http://stackoverflow.com/questions/20260434/test-significance-of-clusters-on-a-pca-plot
#either get the codon frequency, coverage, and annotation using a function
#such as codonInfo in this package
#or create a list of matrices with the above information
data(codonDataCtrl)
codonData <- codonDataCtrl
codonUsage <- codonData[[1]]
codonCovMatrix <- codonData[[2]]

#keep only genes with a minimum number of reads
nbrReadsGene <- apply(codonCovMatrix, 1, sum)
ixExpGenes <- which(nbrReadsGene >= 50)
codonCovMatrix <- codonCovMatrix[ixExpGenes, ]

#get the PCA on the codon coverage
codonCovMatrixTransp <- t(codonCovMatrix)
rownames(codonCovMatrixTransp) <- colnames(codonCovMatrix)
colnames(codonCovMatrixTransp) <- rownames(codonCovMatrix)

listPCACodonCoverage <- codonPCA(codonCovMatrixTransp,"codonCoverage")
print(listPCACodonCoverage[[2]])
#See aditional examples in the pdf manual
}

