% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/URL_helpers.R
\name{browseRC}
\alias{browseRC}
\title{Browse a gene on Ribocrypt webpage}
\usage{
browseRC(
  symbol = NULL,
  gene_id = NULL,
  tx_id = NULL,
  exp = "all_merged-Homo_sapiens_modalities",
  libraries = NULL,
  leader_extension = 0,
  trailer_extension = 0,
  viewMode = FALSE,
  other_tx = FALSE,
  plot_on_start = TRUE,
  frames_type = "columns",
  kmer = 1,
  add_translons = FALSE,
  zoom_range = NULL,
  host = "https://ribocrypt.org",
  browser = getOption("browser")
)
}
\arguments{
\item{symbol}{gene symbol, default NULL}

\item{gene_id}{gene symbol, default NULL}

\item{tx_id}{gene symbol, default NULL}

\item{exp}{experiment name, default "all_merged-Homo_sapiens_modalities"}

\item{libraries}{NULL, default to first in experiment, c("RFP","RNA") would add RNA to default.}

\item{leader_extension}{integer, default 0. (How much to extend view upstream)}

\item{trailer_extension}{integer, default 0. (How much to extend view downstream)}

\item{viewMode}{FALSE (transcript view), TRUE gives genomic.}

\item{other_tx}{FALSE, show all other annotation in region (isoforms etc.)}

\item{plot_on_start}{logical, default TRUE. Plot gene when opening browser.}

\item{frames_type}{"columns"}

\item{kmer}{integer, default 1 (no binning), binning size of windows, to smear out the signal.}

\item{add_translons}{logical, default FALSE. If TRUE, add translons predicted sequences in annotation.}

\item{zoom_range}{character, zoom values.}

\item{host}{url, default "https://ribocrypt.org". Set to localhost for local version.}

\item{browser}{getOption("browser")}
}
\value{
browseURL, opens browse with page
}
\description{
Can also disply local RiboCrypt app if specified in the 'host' argument.
}
\examples{
browseRC("ATF4", "ENSG00000128272")

}
