% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mySpatialPreprocess.R
\name{mySpatialPreprocess}
\alias{mySpatialPreprocess}
\title{Perform Preprocessing for spatial data (tailored from BayesSpace function)}
\usage{
mySpatialPreprocess(
  sce,
  platform = c("Visium", "ST"),
  n.PCs = 15,
  n.HVGs = 2000,
  skip.PCA = FALSE,
  assay.type = "logcounts"
)
}
\arguments{
\item{sce}{A SingleCellExperiment object.}

\item{platform}{Which platform the data are from, Visium or ST.}

\item{n.PCs}{Number of PCs used in the analysis.}

\item{n.HVGs}{Number of highly variable genes used in the analysis.}

\item{skip.PCA}{A boolean variable to choose whether skipping the PCA step or not.}

\item{assay.type}{Which assay to use, default is logcounts.}
}
\value{
A processed SingleCellExperiment object.
}
\description{
Perform Preprocessing for spatial data (tailored from BayesSpace function)
}
\examples{
data(example_sce)
example_sce <- mySpatialPreprocess(example_sce, platform="Visium")

}
