% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_Enrich}
\alias{plot_Enrich}
\alias{plot_Enrich,RegenrichSet-method}
\title{Plot results of FET/GSEA enrichment analysis}
\usage{
plot_Enrich(object, ...)

\S4method{plot_Enrich}{RegenrichSet}(
  object,
  reg = NULL,
  showCategory = 20,
  regDescription = NULL,
  font.size = 12
)
}
\arguments{
\item{object}{a \code{RegenrichSet} object.}

\item{...}{other parameters.}

\item{reg}{The regulator to plot. This only works when the
GSEA enrichment method has used.}

\item{showCategory}{the number of regulator to plot.}

\item{regDescription}{NULL or a two-column data frame, in which
first column is the regulator IDs (for
example ENSEMBL IDs), and the second column is the description
of regulators (for example gene
name). Default is NULL, meaning both columns are the same regulator 
names/IDs in the network.}

\item{font.size}{font size of axis labels and axis tick mark
labels, default is 12.}
}
\value{
a ggplot object of plotting FET or GSEA enrichment result.
}
\description{
Plot FET/GSEA enrichment results. If the FET method is applied,
the top `showCategory` regulator will be plotted.
If the GSEA method is applied, the GSEA graph of regulator `reg`
will be plotted.
}
\examples{
# library(RegEnrich)
data("Lyme_GSE63085")
data("TFs")

data = log2(Lyme_GSE63085$FPKM + 1)
colData = Lyme_GSE63085$sampleInfo

# Take first 2000 rows for example
data1 = data[seq(2000), ]

design = model.matrix(~0 + patientID + week, data = colData)
object = RegenrichSet(expr = data1,
                      colData = colData,
                      method = "limma", minMeanExpr = 0,
                      design = design,
                      contrast = c(rep(0, ncol(design) - 1), 1),
                      networkConstruction = "COEN",
                      enrichTest = "FET")
# Differential expression analysis
object = regenrich_diffExpr(object)
# Network inference using "COEN" method
object = regenrich_network(object)
# Enrichment analysis by Fisher's exact test (FET)
object = regenrich_enrich(object)
# plot
plot_Enrich(object)

# Enrichment analysis by Fisher's exact test (FET)
object = regenrich_enrich(object, enrichTest = "GSEA")
# plot
plot_Enrich(object)
}
