% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regenrichClasses.R
\docType{class}
\name{Score-class}
\alias{Score-class}
\alias{newScore}
\title{Score class}
\usage{
newScore(
  reg = character(),
  negLogPDEA = numeric(),
  negLogPEnrich = numeric(),
  logFC = numeric(),
  score = numeric()
)
}
\arguments{
\item{reg}{character, regulator IDs.}

\item{negLogPDEA}{numeric, -log(p_DEA).}

\item{negLogPEnrich}{numeric, -log(p_Enrich).}

\item{logFC}{numeric, log2 fold change.}

\item{score}{numeric, RegEnrich ranking score.}
}
\value{
newScore function returns a \code{Score} object.
}
\description{
`Score` class inherits tibble ("tbl"). The objects of `Score` class 
are to store information of regulator ranking scores.
}
\section{Slots}{

\describe{
\item{\code{names}}{character vector, containing "reg", "negLogPDEA",
"negLogPEnrich", "logFC", and "score".}

\item{\code{.Data}}{a list of length 5, each elements corresponds to the 
\code{names} slots.}

\item{\code{row.names}}{character, regulators corresponding to \code{.Data} slot.}

\item{\code{.S3Class}}{character vector, containing "tbl_df", "tbl", "data.frame",
indicating the classes that `Score` class inherits.}
}}

\examples{
newScore()
newScore(letters[1:5], 1:5, 1:5, -2:2, seq(2, 1, len = 5))
}
