/*
 * Decompiled with CFR 0.152.
 */
package reder.application.io;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JPanel;

public class PrintImage
implements Printable {
    private final JPanel exportpanel;

    public PrintImage(JPanel jp) {
        this.exportpanel = jp;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        double imgx = pf.getImageableX();
        double imgy = pf.getImageableY();
        g2d.translate(imgx / 2.0, imgy / 2.0);
        float sc = (float)((pf.getWidth() - imgx) / (double)this.exportpanel.getWidth());
        g2d.scale(sc, sc);
        this.exportpanel.paint(g2d);
        return 0;
    }

    public int actionPerformed() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this);
        boolean ok = job.printDialog();
        if (ok) {
            try {
                job.print();
            }
            catch (PrinterException ex) {
                return 1;
            }
            return 0;
        }
        return 0;
    }
}

