% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_request.R
\name{add_dataset,ReactomeAnalysisRequest,EList-method}
\alias{add_dataset,ReactomeAnalysisRequest,EList-method}
\title{add_dataset - EList}
\usage{
\S4method{add_dataset}{ReactomeAnalysisRequest,EList}(
  request,
  expression_values,
  name,
  type,
  comparison_factor,
  comparison_group_1,
  comparison_group_2,
  sample_data = NULL,
  additional_factors = NULL,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{request}{ReactomeAnalysisRequest.}

\item{expression_values}{EList. Here, the sample_data is automaticall extracted from the \code{expression_values} object unless \code{sample_data}
is specified as well.}

\item{name}{character. Name of the dataset. This must be unique within one request.}

\item{type}{character. The type of the dataset. Get available types using \code{\link{get_reactome_data_types}}}

\item{comparison_factor}{character. The name of the sample property to use for the main comparison. The sample properties
are either retrieved from \code{expression_values} or from \code{sample_data}.}

\item{comparison_group_1}{character. Name of the first group within \code{comparison_factor} to use for the comparison.}

\item{comparison_group_2}{character. Name of the second group within \code{comparison_factor} to use for the comparison.}

\item{sample_data}{data.frame (optional) data.frame containing the sample metadata of the \code{expression_values}. Depending
on the object type of \code{expression_values}, this information can also be extracted from there.}

\item{additional_factors}{vector. Vector of additional sample properties that are used as blocking factors
(if supported by the chosen analysis method) in the gene set analysis.}

\item{overwrite}{boolean. If set to \code{TRUE}, datasets with the same name will be overwritten}

\item{...}{Additional parameters passed to downstream functions. See the respective documentation of
whether any additional parameters are supported.}
}
\value{
The \code{\link{ReactomeAnalysisRequest}} object with the added dataset
}
\description{
Adds a dataset to the analysis request
}
\examples{
# create a request using Camera as an analysis
library(ReactomeGSA.data)
data(griss_melanoma_proteomics)
library(methods)

my_request <- ReactomeAnalysisRequest(method = "Camera")

# since the expression_values object is a limma EList object, the sample_data is
# retrieved from there

# add the dataset
my_request <- add_dataset(request = my_request,
                          expression_values = griss_melanoma_proteomics,
                          name = "Proteomics",
                          type = "proteomics_int",
                          comparison_factor = "condition",
                          comparison_group_1 = "MOCK",
                          comparison_group_2 = "MCM",
                          additional_factors = c("cell.type", "patient.id"))
}
\seealso{
Other add_dataset methods: 
\code{\link{add_dataset}()},
\code{\link{add_dataset,ReactomeAnalysisRequest,DGEList-method}},
\code{\link{add_dataset,ReactomeAnalysisRequest,ExpressionSet-method}},
\code{\link{add_dataset,ReactomeAnalysisRequest,data.frame-method}},
\code{\link{add_dataset,ReactomeAnalysisRequest,matrix-method}}
}
\concept{add_dataset methods}
