% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_addLogo.R
\name{showLogo}
\alias{showLogo}
\title{Show RcisTarget as HTML}
\usage{
showLogo(
  motifEnrDT,
  motifCol = c("motif", "bestMotif", "MotifID"),
  dbVersion = NULL,
  nSignif = 3,
  colsToShow = c(motifEnrichment = c("motifDb", "logo", "NES", "geneSet", "TF_highConf"),
    regulonTargets = c("TF", "gene", "nMotifs", "bestMotif", "logo", "NES",
    "highConfAnnot", "Genie3Weight")),
  options = list(pageLength = 50),
  ...
)
}
\arguments{
\item{motifEnrDT}{Results from RcisTarget (data.table)}

\item{motifCol}{Name of the column which contains the logo ID.}

\item{dbVersion}{For current databases (version 10) use "v10nr_clust"}

\item{nSignif}{Number of digits to show in numeric columns.}

\item{colsToShow}{Columns to show in the HTML 
(by default, the list of the enriched genes is hidden)}

\item{options}{List of options to pass to \code{DT::databable}}

\item{...}{Other arguments to pass to \code{DT::databable}}
}
\value{
Returns the DT::datatable() object which can be shown as HTML.
}
\description{
Shows the results motif enrichment table as an HTML 
including the motif logos. Note that Transfac-Pro logos cannot be shown.
}
\examples{
# Run the enrichment (or load previous results)
load(paste(file.path(system.file('examples', package='RcisTarget')),
           "motifEnrichmentTable_wGenes.RData", sep="/"))

# Show table as HTML
showLogo(motifEnrichmentTable_wGenes)
}
\seealso{
See the package vignette for more examples:
\code{vignette("RcisTarget")}
}
