% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_reRank.R
\name{reRank}
\alias{reRank}
\title{Re-rank RcisTarget ranking}
\usage{
reRank(rankingsDb, columns = NULL)
}
\arguments{
\item{rankingsDb}{Results from RcisTarget (data.table)}

\item{columns}{Whether to add the HTML tag <img> around the URL or not
(boolean).}
}
\value{
Returns a new ranking database with the new ranking values.
}
\description{
Re-ranks the genes/regions in the database for each motif. This allows to do motif enrichment over a background.
}
\examples{

library(RcisTarget.hg19.motifDBs.cisbpOnly.500bp)
data(hg19_500bpUpstream_motifRanking_cispbOnly)
motifRankings <- hg19_500bpUpstream_motifRanking_cispbOnly


genes <- colnames(getRanking(motifRankings))[10:20]
reRank(motifRankings, columns=genes)
}
\seealso{
See the "background" vignette for more examples:
\code{vignette("RcisTarget-withBackground")}
}
