% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_rankingRcisTarget.R
\docType{class}
\name{rankingRcisTarget-class}
\alias{rankingRcisTarget-class}
\alias{rankingRcisTarget}
\alias{show,rankingRcisTarget-method}
\alias{getRanking}
\alias{getRanking,rankingRcisTarget-method}
\alias{nrow,rankingRcisTarget-method}
\alias{ncol,rankingRcisTarget-method}
\alias{colnames,rankingRcisTarget-method}
\alias{rownames,rankingRcisTarget-method}
\alias{getMaxRank}
\alias{getMaxRank,rankingRcisTarget-method}
\alias{getNumColsInDB}
\alias{getNumColsInDB,rankingRcisTarget-method}
\title{Class to store the motif databases for RcisTarget.}
\usage{
\S4method{show}{rankingRcisTarget}(object)

\S4method{getRanking}{rankingRcisTarget}(object)

\S4method{nrow}{rankingRcisTarget}(x)

\S4method{ncol}{rankingRcisTarget}(x)

\S4method{colnames}{rankingRcisTarget}(x)

\S4method{rownames}{rankingRcisTarget}(x)

\S4method{getMaxRank}{rankingRcisTarget}(x)

\S4method{getNumColsInDB}{rankingRcisTarget}(x)
}
\arguments{
\item{object}{[method: show] rankingRcisTarget object to show}

\item{x}{[several methods] rankingRcisTarget object to apply the method}
}
\value{
\itemize{
\item show: Prints a summary of the object
\item getRanking: Returns the rankings
\item ncol, nrow: Returns the number of columns or rows of the ranking
}
}
\description{
This class contains the rankings used by RcisTarget. 

They are typically loaded from a .feather file with \code{importRankings()}.

If the associated .descr file is available, 
it will also load the description of the database.

Class slots:

\itemize{
\item rankings: data.frame (tbl_df) containing the rankings
\item colType: 'gene'or 'region'
\item rowType: 'motif' or the type of feature is stored (e.g. ChipSeq)
\item org: human/mouse/fly
\item genome: hg19, mm9, ...
\item nColsInDB: Number of columns (e.g. genes/regions) available 
in the database (.feather file). 
Note that not all might be loaded in the current object.
\item description: global description, summary, or any other information
\item maxRank: Maximum ranking included in the database, 
higher values are converted to Inf.
}

Note that the main slot is \code{@rankings}, 
which is the one used by RcisTarget 
(it can accessed with \code{getRanking()}).
The 'description' slots are mostly for user convenience.
}
\examples{
## Loading from a .feather file:
# dbFile <- "hg19-500bp-upstream-7species.mc9nr.feather"
# motifRankings <- importRankings(dbFile)
# motifRankings

## Loading a built object:
library(RcisTarget.hg19.motifDBs.cisbpOnly.500bp)
data("hg19_500bpUpstream_motifRanking_cispbOnly")
hg19_500bpUpstream_motifRanking_cispbOnly
class(hg19_500bpUpstream_motifRanking_cispbOnly)
}
