% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_importRankings.R
\name{importRankings}
\alias{importRankings}
\alias{getRowNames}
\alias{getColumnNames}
\title{Import the motif databases for RcisTarget.}
\usage{
importRankings(
  dbFile,
  indexCol = NULL,
  colType = "gene",
  columns = NULL,
  warnMissingColumns = TRUE,
  dbDescr = NULL
)

getRowNames(dbFile, indexCol = NULL)

getColumnNames(dbFile)
}
\arguments{
\item{dbFile}{.feather or .parquet file containing the rankings}

\item{indexCol}{Column name containing the feature IDs (e.g. motif names or chip-seq tracks). If NULL, it will try to use 'motifs', 'tracks', or 'features'.}

\item{colType}{Colum type. i.e.:'gene'or 'region'}

\item{columns}{Columns to load from the .feather or .parquet file
(e.g. to read only specific genes or regions)}

\item{warnMissingColumns}{If 'columns' is provided, warn if any ID is not available in the rankings?}

\item{dbDescr}{Description fields (not used in the analysis, just for convenience of the user) 
e.g.:
\code{dbDescr=list(colType="gene", rowType="motif",
org="Human", genome="hg19", maxRank=Inf, description="")}}
}
\value{
rankingRcisTarget object with the following slots:
#' \itemize{
\item rankings: data.frame containing the rankings
\item colType: 'gene'or 'region'
\item nColsInDB: Number of columns (e.g. genes/regions) available
in the database (.feather or .parquet file).
Note that not all might be loaded in the current object.
\item rowType: 'motif' or the type of feature is stored (e.g. ChipSeq)
\item org: human/mouse/fly
\item genome: hg19, mm9, ...
\item description: global description, summary, or any other information
\item maxRank: Maximum ranking included in the database,
higher values are converted to Inf.
}
}
\description{
The rankings are typically loaded from a .feather or .parquet file
with \code{importRankings()}.
}
\examples{
## Loading from a .feather or .parquet file:
# dbFilePath = "hg38_10kbp_up_10kbp_down_full_tx_v10_clust.genes_vs_motifs.rankings.feather"
# motifRankings<-importRankings(dbFilePath)

## The annotations for Motif collection 9 (sufix 'mc9nr')
# are included in RcisTarget, and can be loaded with:
data(motifAnnotations_hgnc)

## For other versions, import the appropiate annotation. e.g.:
# annotDb <- importAnnotations("motifs-v10nr_clust-nr.hgnc-m0.001-o0.0.tbl")
# optional: motifsInRanking <- getRanking(motifRankings)$motifs
}
