% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multipleFamilyCalculations.R
\name{enrichmentPValue}
\alias{enrichmentPValue}
\title{enrichment p-value across multiple families and variants}
\usage{
enrichmentPValue(snpMat, famInfo, sharingProbs, threshold = 0)
}
\arguments{
\item{snpMat}{SnpMatrix}

\item{famInfo}{data frame containing pedigree, member, father, mother,
sex, affected fields for each sequenced subject}

\item{sharingProbs}{vector of sharing probabilites, must be a named vector
with famid's for each probability}

\item{threshold}{minimum p-value threshold passed to multipleFamilyPValue}
}
\value{
p-value
}
\description{
Computes a p-value for all variants seen across all families
}
\details{
For each variant, the families which have all sequenced subjects
sharing the variant and the families which have some sequenced subjects
sharing the variant are recorded. All unique (family, variant) pairs
are accumulated into a single vector and passed to multipleFamilyPValue
}
\references{
Fu, J., Beaty, T.H., Scott, A.F., Hetmanski, J., Parker, M.M.,
Bailey-Wilson, J.E., Marazita, M.L., et al. 2017. Whole Exome Association of
Rare Deletions in Multiplex Oral Cleft Families. Genetic Epidemiology 41
(1): 61–69. doi:10.1002/gepi.22010.
}
