% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVgene.R
\name{RVgene}
\alias{RVgene}
\title{Probability of sharing of rare variants in a family sample within a gene}
\usage{
RVgene(
  data,
  ped.listfams,
  sites,
  fams,
  pattern.prob.list,
  nequiv.list,
  N.list,
  type = "alleles",
  minor.allele.vec,
  precomputed.prob = list(0),
  maxdim = 1e+09,
  partial.sharing = TRUE,
  ...
)
}
\arguments{
\item{data}{A list of \code{SnpMatrix} objects corresponding to each pedigree
object in ped.listfams, or a data.frame or matrix encoding
the pedigree information and genotype data in the standard LINKAGE ped
format or the PLINK raw format with additive component only 
(see PLINK web site [1]). From the pedigree information, only the family ID 
in the first column, the subject ID in the second column and the affection 
status in the sixth column are used
(columns 3 to 5 are ignored). Also, family members without genotype data do
not need to appear in this object. The genotype of each variant can be
coded in two ways, each corresponding to a different value of the type
option: a minor allele count on one column with missing values coded NA,
(type="count") or the identity of the two alleles on two consecutive columns,
with missing values coded 0 corresponding to the standard
LINKAGE ped format (type="alleles"). If you provide a \code{SnpMatrix} object
then the genotype should be coded as the minor allele count + 1, i.e. 01 is the
homozygous genotype for the common allele.}

\item{ped.listfams}{a list of \code{pedigree} objects, one object for each
pedigree for which genotype data are included in \code{data}.}

\item{sites}{a vector of the column indices of the variant sites to
test in \code{data}. If the argument fams is provided, the variant sites
are tested in each corresponding family in the fams vector (a variant
present in multiple families must then be repeated for every families
where it appears).}

\item{fams}{an optional character vector of the names of families
in \code{data} and \code{ped.listfams} carrying the variants listed in the 
corresponding position in \code{sites}. If missing, the names of the families 
carrying the minor allele at each position in \code{sites} are extracted from 
\code{data}}

\item{pattern.prob.list}{a list of precomputed rare variant sharing 
probabilities for all possible sharing patterns in the families in 
\code{data} and \code{ped.listfams}}

\item{nequiv.list}{an optional vector of the number of configurations 
of rare variant sharing by the affected subjects corresponding to the 
same pattern and probability in \code{pattern.prob.list}. Default is a vector 
of 1s}

\item{N.list}{a vector of the number of affected subjects sharing a 
rare variant in the corresponding pattern in \code{pattern.prob.list}}

\item{type}{an optional character string taking value "alleles" or 
"count". Default is "alleles"}

\item{minor.allele.vec}{an optional vector of the minor alleles at each 
site in the \code{sites} vector. It is not needed if type="count". If it is 
missing and type="alleles", the minor allele is assumed to take the 
value 2}

\item{precomputed.prob}{an optional list of vectors precomputed rare 
variant sharing probabilities for families in \code{data} and \code{ped.listfams}. 
If the vectors are named, the names must be strings formed by the 
concatenation of the sorted carrier names separated by semi-columns. 
If the vectors are not 
named, the vectors must represent probabilities for all the possible 
values of \code{N.list} for the corresponding family (one probability per 
value of \code{N.list})}

\item{maxdim}{upper bound on the dimension of the array containing the 
joint distribution of the sharing patterns for all families in fams 
(to avoid running out of memory)}

\item{partial.sharing}{logical indicating whether the test allowing for sharing
by a subset of affected subjects should be performed. If FALSE, only 
the test requiring sharing
by all affected subjects is computed. Default is TRUE}

\item{...}{other arguments to be passed to RVsharing}
}
\value{
A list with items:
\code{p} P-value of the exact rare variant sharing test allowing for sharing
by a subset of affected subjects.
\code{pall} P-value of the exact rare variant sharing test requiring sharing
by all affected subjects.
\code{potentialp} Minimum achievable p-value if all affected subjects were
carriers of a rare variant.
}
\description{
Computing probability of sharing of rare variants in
a family sample within a genomic region such as a gene.
}
\details{
The function extracts the carriers of the minor allele at each
entry in sites in each family where it is present in ped.mat (or in the
families specified in fams if that argument is specified). It then
computes exact rare variant sharing probabilities in each family for
each variant by calling \code{RVsharing}. If multiple rare variants are seen
in the same family, the smallest sharing probability among all rare
variants is retained. The joint rare variant sharing probability over
all families is obtained as the product of the family-specific
probabilities. The p-value of the test allowing for sharing by a subset
of affected subjects over the rare variants in the genomic region is
then computed as the sum of the probabilities of the possible
combinations of sharing patterns among all families with a probability
less than or equal to the observed joint probability and a total number
of carriers greater than or equal to the sum of the number of carriers
in all families, using the values in \code{pattern.prob.list}, \code{nequiv.list} and
\code{N.list}. The families where all affected subjects share a rare variant
are determined by verifying if the length of the carrier vector equals
the maximum value of \code{N.list} for that family. The p-value of the test
requiring sharing by all affected subjects is computed by calling
\code{multipleFamilyPValue}.
}
\examples{
data(samplePedigrees)
data(ex.ped.mat)
fam15157 <- samplePedigrees$secondCousinTriple
fam15157.pattern.prob = c(RVsharing(fam15157,carriers=c(15,16,17)),
    RVsharing(fam15157,carriers=c(15,16)),
    RVsharing(fam15157,carriers=c(15)))
fam15157.nequiv = c(1,3,3)
# check that distribution sums to 1
sum(fam15157.pattern.prob*fam15157.nequiv)
fam15157.N = 3:1
fam28003 <- samplePedigrees$firstAndSecondCousinsTriple
fam28003.pattern.prob = c(RVsharing(fam28003,carriers=c(36,104,110)),
    RVsharing(fam28003,carriers=c(36,104)),
    RVsharing(fam28003,carriers=c(104,110)),
    RVsharing(fam28003,carriers=c(36)),
    RVsharing(fam28003,carriers=c(104)))
fam28003.N = c(3,2,2,1,1)
fam28003.nequiv = c(1,2,1,1,2)
# check that distribution sums to 1
sum(fam28003.pattern.prob*fam28003.nequiv)
# Creating lists
ex.pattern.prob.list = list("15157"=fam15157.pattern.prob,"28003"=fam28003.pattern.prob)
ex.nequiv.list = list("15157"=fam15157.nequiv,"28003"=fam28003.nequiv)
ex.N.list = list("15157"=fam15157.N,"28003"=fam28003.N)
ex.ped.obj = list(fam15157,fam28003)
names(ex.ped.obj) = c("15157","28003")
sites = c(92,119)
minor.allele.vec=c(1,4)
RVgene(ex.ped.mat,ex.ped.obj,sites,
    pattern.prob.list=ex.pattern.prob.list,
nequiv.list=ex.nequiv.list,N.list=ex.N.list,
    minor.allele.vec=minor.allele.vec)
# calling with a SnpMatrix list
data(famVCF)
fam15157.snp = suppressWarnings(VariantAnnotation::genotypeToSnpMatrix(fam15157.vcf))
fam28003.snp = suppressWarnings(VariantAnnotation::genotypeToSnpMatrix(fam28003.vcf))
ex.SnpMatrix.list = list(fam15157=fam15157.snp$genotypes,fam28003=fam28003.snp$genotypes)
RVgene(ex.SnpMatrix.list,ex.ped.obj,sites,
    pattern.prob.list=ex.pattern.prob.list, nequiv.list=ex.nequiv.list,
    N.list=ex.N.list,minor.allele.vec=minor.allele.vec)
}
\references{
Bureau, A., Begum, F., Taub, M.A., Hetmanski, J., Parker, M.M.,
Albacha-Hejazi, H., Scott, A.F., et al. (2019) Inferring Disease Risk Genes
from Sequencing Data in Multiplex Pedigrees Through Sharing of Rare Variants.
Genet Epidemiol. 43(1):37-49. doi: 10.1002/gepi.22155.
}
