% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wcor.R
\name{wcor}
\alias{wcor}
\title{Calculate weighted correlations.}
\usage{
wcor(X, anno, Factor, Weights)
}
\arguments{
\item{X}{A matrix of gene expression values.}

\item{anno}{A dataframe or a matrix containing the annotation of arrays in \code{X}.}

\item{Factor}{A character string corresponding to a column name of \code{anno}; this
should be the same used to generate \code{Weights}.}

\item{Weights}{An object of class \code{Weights} or a list of weights.}
}
\value{
\code{wcor} returns a matrix.
}
\description{
\code{wcor} returns correlations weighted according to a provided object of
class \code{Weights}.
}
\examples{
Y<-simulateGEdata(500, 500, 10, 2, 5, g=NULL, Sigma.eps=0.1, 
250, 100, intercept=FALSE, check.input=FALSE)
anno<-as.matrix(sample(1:5, dim(Y$Y)[1], replace=TRUE))
colnames(anno)<-"Factor"
weights<-findWeights(Y$Y, anno, "Factor")
wcor(Y$Y[,1:5], anno, "Factor", weights)
}
\author{
Saskia Freytag
}
