% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDesign.R
\name{plotDesign}
\alias{plotDesign}
\title{Plot nested design structure.}
\usage{
plotDesign(anno, Factors, anno.names = Factors, orderby = NULL)
}
\arguments{
\item{anno}{A dataframe or matrix containing the annotation of the study.}

\item{Factors}{A vector of factors that should be plotted.}

\item{anno.names}{A vector containing the names, the default \code{Factors}.}

\item{orderby}{A character describing an element in \code{Factor} by which the 
data should be ordered.}
}
\value{
\code{plotDesign} returns a plot.
}
\description{
\code{plotDesign} returns a plot with different color strips representing
different factors relating to the study design.
genes.
}
\examples{
library(bladderbatch)
data(bladderdata)
expr.meta <- pData(bladderEset)
plotDesign(expr.meta, c("cancer", "outcome", "batch"), 
c("Diagnosis", "Outcome", "Batch"), orderby="batch")
}
\author{
Saskia Freytag
}
