% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful_functions.R
\name{heatmap_compare_corr}
\alias{heatmap_compare_corr}
\title{Plot pearson correlation coefficients between markers on a double triangular heatmap (lower triangle: before RUCova, upper triangle: after RUCova). If RUCova has not been applied, the output is a symmetric heatmap.}
\usage{
heatmap_compare_corr(
  sce,
  name_assay_before = "counts",
  name_assay_after = NULL,
  name_reduced_dim = NULL
)
}
\arguments{
\item{sce}{A SingleCellExperiment object with markers and SUCs in linear scale stored in the assay "name_assay". Asinh transformation is applied within the function.}

\item{name_assay_before}{A string specifying the name of the assay before RUCova (with original counts in linear scale).}

\item{name_assay_after}{A string specifying the name of the assay before RUCova (with original counts in linear scale).}

\item{name_reduced_dim}{A string specifying the name of the dimensionality reduction data stored under \code{reducedDim()}. If "PCA", then PCs will be included in the heatmao.}
}
\value{
#A heatmap with pearson correlation coefficients.
}
\description{
Plot pearson correlation coefficients between markers on a double triangular heatmap (lower triangle: before RUCova, upper triangle: after RUCova). If RUCova has not been applied, the output is a symmetric heatmap.
}
\examples{
sce <- RUCova::sce
bc_channels <- c("Pd102Di", "Pd104Di", "Pd105Di", "Pd106Di", "Pd108Di", "Pd110Di",
"Dead_cells_194Pt", "Dead_cells_198Pt")
sce <- RUCova::calc_mean_BC(sce, name_assay = "counts", bc_channels, n_bc = 4, q = 0.95)
dna_channels <- c("DNA_191Ir", "DNA_193Ir")
sce <- RUCova::calc_mean_DNA(sce, name_assay = "counts", dna_channels, q = 0.95)
# Markers:
m <- c("pH3","IdU","Cyclin_D1","Cyclin_B1", "Ki.67","pRb","pH2A.X","p.p53","p.p38",
"pChk2","pCDC25c","cCasp3","cPARP","pAkt","pAkt_T308","pMEK1.2","pERK1.2","pS6","p4e.BP1",
"pSmad1.8","pSmad2.3","pNFkB","IkBa", "CXCL1","Lamin_B1", "pStat1","pStat3", "YAP","NICD")
# SUCs::
x <- c("total_ERK", "pan_Akt", "mean_DNA", "mean_BC")
sce <- RUCova::rucova(sce = sce, name_assay_before = "counts", markers = m, SUCs = x, 
apply_asinh_SUCs = TRUE,  model = "interaction", center_SUCs = "across_samples", 
col_name_sample = "line", name_assay_after = "counts_interaction")
heatmap_compare_corr(sce[,sce$line == "Cal33"], name_assay_before = "counts", name_assay_after = "counts_interaction")
}
