% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllSupplements.R
\name{tnsStratification}
\alias{tnsStratification}
\title{Sample stratification for a TNS object}
\usage{
tnsStratification(
  tns,
  sections = 1,
  center = FALSE,
  undetermined.status = TRUE
)
}
\arguments{
\item{tns}{a \linkS4class{TNS} object, which must have passed GSEA2 analysis.}

\item{sections}{A numeric value for the stratification of the sample. The 
larger the number, the more subdivisions will be created for the Kaplan-Meier 
analysis.}

\item{center}{a logical value. If TRUE, numbers assigned to each group is
centralized on regulon activity scale.}

\item{undetermined.status}{a logical value. If TRUE, regulons assigned as 
'undetermined' will form a group.}
}
\value{
An updated \linkS4class{TNS} object.
}
\description{
Internal function, used for sample stratification.
}
\examples{
# see tnsKM method.

}
\seealso{
\code{\link{tnsKM}}
}
