% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_RTCGA.R
\name{theme_RTCGA}
\alias{theme_RTCGA}
\title{RTCGA Theme for ggplot2}
\usage{
theme_RTCGA(base_size = 11, base_family = "", ...)
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}

\item{...}{Further arguments passed to \link[ggthemes]{theme_pander}.}
}
\description{
Additional \pkg{RTCGA} theme for \link[ggplot2]{ggtheme}, based on \link[ggthemes]{theme_pander}.
}
\section{Issues}{


If you have any problems, issues or think that something is missing or is not
clear please post an issue on 
\href{https://github.com/RTCGA/RTCGA/issues}{https://github.com/RTCGA/RTCGA/issues}.
}

\examples{

library(RTCGA.clinical)
survivalTCGA(BRCA.clinical, OV.clinical, extract.cols = "admin.disease_code") -> BRCAOV.survInfo
kmTCGA(BRCAOV.survInfo, explanatory.names = "admin.disease_code",
			 xlim = c(0,4000))
					 
}
\seealso{
\pkg{RTCGA} website \href{http://rtcga.github.io/RTCGA/articles/Visualizations.html}{http://rtcga.github.io/RTCGA/articles/Visualizations.html}.

Other RTCGA: 
\code{\link{RTCGA-package}},
\code{\link{boxplotTCGA}()},
\code{\link{checkTCGA}()},
\code{\link{convertTCGA}()},
\code{\link{datasetsTCGA}},
\code{\link{downloadTCGA}()},
\code{\link{expressionsTCGA}()},
\code{\link{heatmapTCGA}()},
\code{\link{infoTCGA}()},
\code{\link{installTCGA}()},
\code{\link{kmTCGA}()},
\code{\link{mutationsTCGA}()},
\code{\link{pcaTCGA}()},
\code{\link{readTCGA}()},
\code{\link{survivalTCGA}()}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\concept{RTCGA}
