% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphWeights.R
\name{setEdgeWeights}
\alias{setEdgeWeights}
\title{Set gene weights based on edge type}
\usage{
setEdgeWeights(graphList, edgeTypeAttr = "subtype",
  edgeWeightByType = list(activation = 1, inhibition = -1, expression = 1,
  repression = -1), defaultWeight = 0, combineWeights = sum,
  nodeOnlyGraphs = FALSE)
}
\arguments{
\item{graphList}{a list of \code{\link{graphNEL}} objects}

\item{edgeTypeAttr}{edge attribute to be considered as the edge type. If the edge has multiple types, 
the edge type attribute is considered as a comma separeted list of types}

\item{edgeWeightByType}{named list of weigths, where the names of the list are the 
edge type (values of the attribute defined by \code{edgeTypeAttr})}

\item{defaultWeight}{default value for an edge with a type not defined in \code{edgeWeightByType}}

\item{combineWeights}{for the edges with multiple types, the function to be applied on the vector of weights}

\item{nodeOnlyGraphs}{boolean value marking if graphs with no edges should be returned or not; note that graphs with all edge weights equal to 0 are considered node only graphs}
}
\value{
The \code{graphList} with the edge weights set.
}
\description{
\code{setEdgeWeights}
}
\examples{

# load the set of pathways
kpg <- keggPathwayGraphs("hsa")

kpg <- setEdgeWeights(kpg)

edgeWeights(kpg[["path:hsa04110"]])

}
\author{
Calin Voichita and Sorin Draghici
}

