% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNAsense.R
\name{getFC}
\alias{getFC}
\title{Detect fold changes}
\usage{
getFC(dataset = mydata, myanalyzeConditions = analyzeConditions,
  cores = 1, mytimes = times)
}
\arguments{
\item{dataset}{Object of class SummarizedExperiment, output of \link{SummarizedExperiment}, as assays use a numeric matrix with your RNAseq count data, rows correspond to different genes, columns correspond to different experiments, as rowData provide a \link{DataFrame} with columns name (geneID) and genename (the gene names), as colData provide a \link{DataFrame} with columns condition, time and replicate}

\item{myanalyzeConditions}{Character vector, Name of experimental conditions}

\item{cores}{Numeric, Number of cores for parallelization, default 1 for no parallelization}

\item{mytimes}{Numeric vector, Time points of the time-resolved RNA-seq data}
}
\value{
Data.frame containing gene names, log fold change and p-values calculated from NBPSeq, each gene appears as often as available time points
}
\description{
For each gene and for each time point, RNA-seq count data is analyzed for fold changes between two experimental conditions. This functions bases on functions from the R package NBPSeq package for fold change analysis
}
\examples{
data(MZsox)
mydata <- MZsox[seq(1,nrow(MZsox), by=10),]
resultFC <- getFC(dataset = mydata,
myanalyzeConditions = c("WT", "MZsox"),
cores = 1,
mytimes = c(2.5,3,3.5,4,4.5,5,5.5,6))
}
\author{
Marcus Rosenblatt, \email{marcus.rosenblatt@fdm.uni-freiburg.de}
}
