% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SequenceDataFrame-class.R
\docType{class}
\name{SequenceDataFrame-class}
\alias{SequenceDataFrame-class}
\alias{SequenceDataFrame}
\alias{cbind,SequenceDataFrame-method}
\alias{[,SequenceDataFrame,ANY,ANY,ANY-method}
\alias{SequenceDFrame-class}
\title{The SequenceDataFrame class}
\usage{
\S4method{cbind}{SequenceDataFrame}(..., deparse.level = 1)

\S4method{[}{SequenceDataFrame,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{x, i, j, ..., drop, deparse.level}{arguments used for 
\code{\link[S4Vectors:DataFrame-class]{subsetting}} or 
\code{\link[base:cbind]{base::cbind}}.}
}
\value{
A \code{SequenceDataFrame} object or if subset to row a 
\code{DataFrame}
}
\description{
The \code{SequenceDataFrame} class is a virtual class and  contains data for
positions along a single transcript. In addition to being used for returning
elements from a \code{SequenceData} object, the SequenceDataFrame class is
used to store the unlisted data within a
\code{\link[=SequenceData-class]{SequenceData}} object. Therefore, a matching
\code{SequenceData} and \code{SequenceDataFrame} class must be implemented.

The \code{SequenceDataFrame} class is derived from the
\code{\link[S4Vectors:DataFrame-class]{DataFrame}} class. To follow the 
functionallity in the \code{S4Vectors} package, \code{SequenceDataFrame} 
implements the concept, whereas \code{SequenceDFrame} is the implementation
for in-memory data representation from which some specific 
\code{*SequenceDataFrame} class derive from, e.g. 
\code{\link[=CoverageSequenceData-class]{CoverageSequenceData}}.

Subsetting of a \code{SequenceDataFrame} returns a \code{SequenceDataFrame} or 
\code{DataFrame}, if it is subset by a column or row, respectively. The 
\code{drop} argument is ignored for column subsetting.
}
\section{Slots}{

\describe{
\item{\code{ranges}}{a \code{\link[GenomicRanges:GRanges-class]{GRanges}} 
object each element describing a transcript including its element. The 
\code{GRanges} is constructed from the unlisted results of the
\code{\link[GenomicFeatures:transcriptsBy]{exonsBy(x, by="tx")}} function.
If during construction a \code{GRangesList} is provided instead of a 
character value pointing to a gff3 file or a \code{TxDb} object, it must have
a comparable structure.}

\item{\code{sequence}}{a \code{\link[Biostrings:XString-class]{XString}} of 
type \code{sequencesType} from the parent 
\code{\link[=SequenceData-class]{SequenceData}} object.}

\item{\code{condition}}{conditions along the 
\code{\link[Rsamtools:BamFile-class]{BamFileList}}: Either \code{control}
or \code{treated}}

\item{\code{replicate}}{replicate number along the \code{BamFileList} for each of the
condition types.}

\item{\code{bamfiles}}{the input bam files as 
\code{\link[Rsamtools:BamFile-class]{BamFileList}}}

\item{\code{seqinfo}}{a \code{\link[Seqinfo:Seqinfo-class]{Seqinfo}} describing
the avialable/used chromosomes.}
}}

\examples{
data(e5sd,package="RNAmodR")
# A SequenceDataFrame can is usually constructed by subsetting from 
# a SequenceData object
sdf <- e5sd[[1]]
# Its also used to store the unlisted data in a SequenceData object
sdf <- unlist(e5sd) # should probably only used internally
e5sd <- relist(sdf,e5sd)
}
\seealso{
for an example see
\code{\link[=ProtectedEndSequenceData-class]{ProtectedEndSequenceData}}
and for more information see \code{\link[=SequenceData-class]{SequenceData}}
}
