% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupings.R
\name{groupings}
\alias{groupings}
\title{Combinatorial groups matrix generator}
\usage{
groupings(decaydata)
}
\arguments{
\item{decaydata}{a data.frame with column names:
'geneID','treatment','t.decay','rep','value' with classes
\code{factor}, \code{factor}, \code{numeric}, \code{factor}, \code{numeric}}
}
\value{
returns a matrix of equivalence group indicies based on the number of levels in the 'treatment' column (max of 4).
}
\description{
Generates a combinatorial grouping matrix based on the \code{decaydata} data.frame.
}
\details{
The resulting matrix of indices is used to constrain treatment alphas or treatment betas in combination. For example, in one model, treatment alphas might be allowed to vary independently (gp1), but the beta models might be constrained to be equal for some treatments indicated by haveing the same index number (other gp).
}
\examples{
groupings(data.frame(geneID=paste0('gene',1:4),treatment=as.factor(paste0('treat',1:4)),
                     t.decay=0:3,rep=rep('rep1'),value=c(1,0.5,0.25,0.12)))

}
