% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_map.R
\name{group_map}
\alias{group_map}
\title{model color map}
\usage{
group_map(decaydata, path, nEquivGrp = nEquivGrp, groups = groups, mods = mods)
}
\arguments{
\item{decaydata}{5 column data.frame with colnames "geneID","treatment","t.decay","rep","value"}

\item{path}{write path and file name, must end in ".pdf"}

\item{nEquivGrp}{number of equivalence groups based on number of treatments}

\item{groups}{equivalence group matrix}

\item{mods}{alpha beta equivalence group usage index (matrix)}
}
\value{
creates a model colormap and writes it to a pdf file named \code{path}
}
\description{
group_map makes a color map of alpha and beta equivalence groups by model. Similar colors in a row indicate constrained parameter equivalence between treatements. Gray indicates values of 0.
}
\examples{
group_map(decaydata=data.frame(geneID=paste0("gene",1:4),
                    treatment=as.factor(rep(paste0("treat",1:2),2)),
                    t.decay=0:3,
                    rep=rep("rep1"),
                    value=c(1,0.5,0.25,0.12)),
         path=paste0(tempdir(),"/parameter equivalence colormap.pdf"),
         nEquivGrp = 2,
         groups = t(matrix(c(1,2,1,1,NA,NA),nrow=2,
                    dimnames=list(c("treat1","treat2"),c("grp1","grp2","grp3")))),
         mods = t(matrix(c(1,1,1,2,1,3,2,1,2,2,2,3),nrow=2,
                         dimnames=list(c("a","b"),paste0("mod",1:6)))))
}
