% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpectraSetMethods.R
\name{spectraCount}
\alias{spectraCount}
\alias{spectraCount,RmbSpectraSet-method}
\alias{spectraCount,RmbSpectraSetList-method}
\alias{spectraCount,msmsWorkspace-method}
\title{Count MS2 spectra per compound}
\usage{
spectraCount(s)

\S4method{spectraCount}{RmbSpectraSet}(s)

\S4method{spectraCount}{RmbSpectraSetList}(s)

\S4method{spectraCount}{msmsWorkspace}(s)
}
\arguments{
\item{s}{The object (\code{RmbSpectraSet}, \code{RmbSpectraSetList} or \code{msmsWorkspace}) to count the spectra in.}
}
\value{
For \code{RmbSpectraSet} objects, a single number counting the spectra in that object. For \code{RmbSpectraSetList} or \code{msmsWorkspace}, a 
vector with spectra counts for all compounds (\code{RmbSpectraSet}s) in the object.
}
\description{
Counts the number of acquired spectra for a compound or multiple compounds
}
\section{Methods (by class)}{
\itemize{
\item \code{spectraCount(RmbSpectraSet)}: Counts the number of acquired spectra for an RmbSpectraSet

\item \code{spectraCount(RmbSpectraSetList)}: Counts the number of acquired spectra for an RmbSpectraSetList

\item \code{spectraCount(msmsWorkspace)}: Counts the number of acquired spectra for an msmsWorkSpace

}}
\author{
stravsmi
}
