% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/SpectrumMethods.R,
%   R/SpectraSetMethods.R, R/AggregateMethods.R
\name{selectPeaks}
\alias{selectPeaks}
\alias{selectPeaks,RmbSpectrum2-method}
\alias{selectPeaks,Spectrum-method}
\alias{selectPeaks,RmbSpectrum2List-method}
\alias{selectPeaks,RmbSpectraSetList-method}
\alias{selectPeaks,RmbSpectraSet-method}
\alias{selectPeaks,data.frame-method}
\alias{selectPeaks,msmsWorkspace-method}
\title{Select peaks from aggregate table}
\usage{
selectPeaks(o, ...)

\S4method{selectPeaks}{RmbSpectrum2}(o, filter, ..., enclos = parent.frame(2))

\S4method{selectPeaks}{Spectrum}(o, filter, ..., enclos = parent.frame(2))

\S4method{selectPeaks}{RmbSpectrum2List}(o, ..., enclos = parent.frame(2))

\S4method{selectPeaks}{RmbSpectraSetList}(o, ..., enclos = parent.frame(2))

\S4method{selectPeaks}{RmbSpectraSet}(o, ..., enclos = parent.frame(2))

\S4method{selectPeaks}{data.frame}(o, filter, ..., enclos = parent.frame(2))

\S4method{selectPeaks}{msmsWorkspace}(o, ..., enclos = parent.frame(2))
}
\arguments{
\item{o}{\code{msmsWorkspace} or aggregate \code{data.frame} from a workspace.}

\item{...}{no additional parameters}

\item{filter}{The expression (to be evaluated in context of the `getData()`
result on the spectrum) to define the peaks to keep. For example, `good & filterOK`}

\item{enclos}{The context in which to evaluate the filter expression, by default set
such that the spectrum `getData()` is retrieved.}
}
\value{
Peak dataframe according to the specified criteria.
}
\description{
Selects peaks from aggregate table according to different criteria.
}
\section{Methods (by class)}{
\itemize{
\item \code{selectPeaks(RmbSpectraSetList)}: A method to filter spectra to the specified peaks

\item \code{selectPeaks(RmbSpectraSet)}: A method to filter spectra to the specified peaks

\item \code{selectPeaks(data.frame)}: A method to retrieve the specified peaks from the "aggregated" slot (a data.frame object) in an msmsWorkSpace

\item \code{selectPeaks(msmsWorkspace)}: A method to retrieve the specified peaks from an msmsWorkSpace

}}
\author{
stravsmi
}
