% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createMassBank.R
\name{gatherPubChem}
\alias{gatherPubChem}
\title{Retrieve supplemental annotation data from Pubchem}
\usage{
gatherPubChem(key)
}
\arguments{
\item{key}{An Inchi-Key}
}
\value{
Returns a list with 4 slots:
\code{PcID} The Pubchem CID
\code{Synonym} An arbitrary synonym for the compound name
\code{IUPAC} A IUPAC-name (preferred if available)
\code{Chebi} The identification number of the chebi database
}
\description{
Retrieves annotation data for a compound from the internet service Pubchem 
based on the inchikey generated by babel or Cactus
}
\details{
The data retrieved is the Pubchem CID, a synonym from the Pubchem database,
the IUPAC name (using the preferred if available) and a Chebi link
}
\examples{

# Gather data for compound ID 131
\dontrun{gatherPubChem("QEIXBXXKTUNWDK-UHFFFAOYSA-N")}

}
\references{
Pubchem REST:
\url{https://pubchem.ncbi.nlm.nih.gov/pug_rest/PUG_REST.html}
Chebi:
\url{http://www.ebi.ac.uk/chebi}
}
\seealso{
\code{\link{mbWorkflow}}
}
\author{
Erik Mueller
}
