% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createMassBank.R
\name{gatherDataBabel}
\alias{gatherDataBabel}
\title{Retrieve annotation data}
\usage{
gatherDataBabel(id)
}
\arguments{
\item{id}{The compound ID.}
}
\value{
Returns a list of type \code{list(id= \var{compoundID}, ...,
'ACCESSION' = '', 'RECORD_TITLE' = '', )} etc. %% ...
}
\description{
Retrieves annotation data for a compound by using babel,
based on the SMILES code and name of the compounds stored in the
compound list.
}
\details{
Composes the "upper part" of a MassBank record filled with chemical data
about the compound: name, exact mass, structure, CAS no..  
The instrument type is also written into this block (even
if not strictly part of the chemical information). Additionally, index
fields are added at the start of the record, which will be removed later:
\code{id, dbcas, dbname} from the compound list.

Additionally, the fields \code{ACCESSION} and \code{RECORD_TITLE} are
inserted empty and will be filled later on.

This function is an alternative to gatherData, in case CTS is down or if information
on one or more of the compounds in the compound list are sparse
}
\examples{

# Gather data for compound ID 131
\dontrun{gatherDataBabel(131)}

}
\references{
MassBank record format:
\url{http://www.massbank.jp/manuals/MassBankRecord_en.pdf}
}
\seealso{
\code{\link{mbWorkflow}}
}
\author{
Michael Stravs, Erik Mueller
}
