% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RJMCMCNucleosomes.R
\docType{data}
\name{reads_demo_01}
\alias{reads_demo_01}
\title{Forward reads and reverse reads in \code{GRanges} format
(for demo purpose).}
\format{A \code{GRanges} containing forward and reverse reads.}
\usage{
data(reads_demo_01)
}
\value{
A \code{GRanges} containing forward and reverse reads.
}
\description{
A group of forward and reverse reads, in a \code{GRanges}, that can be
used to test the \code{rjmcmc} function.
}
\examples{

## Loading dataset
data(reads_demo_01)

## Nucleosome positioning
rjmcmc(reads = reads_demo_01, nbrIterations = 100, lambda = 3, kMax = 30,
            minInterval = 146, maxInterval = 292, minReads = 5)

}
\seealso{
\itemize{
    \item \code{\link{rjmcmc}} {for profiling of nucleosome positions}
}
}
\keyword{datasets}
