% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/print.rjmcmcNucleosomesBeforeAndAfterPostTreatment.R
\name{print.rjmcmcNucleosomesBeforeAndAfterPostTreatment}
\alias{print.rjmcmcNucleosomesBeforeAndAfterPostTreatment}
\title{Formated output of predicted nucleosomes}
\usage{
\method{print}{rjmcmcNucleosomesBeforeAndAfterPostTreatment}(x, ...)
}
\arguments{
\item{x}{the output object from \code{rjmcmcCHR}
function to be printed}

\item{\ldots}{arguments passed to or from other methods}
}
\value{
an object of class
\code{rjmcmcNucleosomesBeforeAndAfterPostTreatment}
}
\description{
Generated a formated output of a list marked as
an \code{rjmcmcNucleosomesBeforeAndAfterPostTreatment} class
}
\examples{

## Load synthetic dataset of reads
data(syntheticNucleosomeReads)

## Use dataset of reads to create GRanges object
sampleGRanges <- GRanges(syntheticNucleosomeReads$dataIP)

## Run nucleosome detection on the entire sample
\dontrun{result <- rjmcmcCHR(reads = sampleGRanges, zeta = 147, delta=50,
maxLength=1200, nbrIterations = 1000, lambda = 3, kMax = 30,
minInterval = 146, maxInterval = 292, minReads = 5, vSeed = 10113,
nbCores = 2, saveAsRDS = FALSE)}

## Print result
\dontrun{print(result)}

}
\author{
Astrid Deschenes
}
