% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjmcmcMethodsIntern.R
\name{mergeAllRDSFiles}
\alias{mergeAllRDSFiles}
\title{Merge nucleosome information}
\usage{
mergeAllRDSFiles(arrayOfFiles)
}
\arguments{
\item{arrayOfFiles}{a \code{array}, the name of each file that must be
used to merge nucleosome information.}
}
\value{
a \code{list} of \code{class} "rjmcmcNucleosomesMerge" containing:
\itemize{
    \item k a \code{integer}, the number of nucleosomes.
    \item \code{mu} a \code{GRanges} containing the positions of the
nucleosomes.
}
}
\description{
Merge nucleosome information present in multiple RDS files.
}
\examples{

## Loading two files containing nucleosomes informations for two sections of
## the same chromosome
file_1 <- dir(system.file("extdata", package = "RJMCMCNucleosomes"),
                pattern = "RJMCMC_seg_01.RDS",
                full.names = TRUE)

file_2 <- dir(system.file("extdata", package = "RJMCMCNucleosomes"),
                pattern = "RJMCMC_seg_02.RDS",
                full.names = TRUE)

## Merging nucleosomes informations from the two files
result <- RJMCMCNucleosomes:::mergeAllRDSFiles(c(file_1, file_2))

}
\author{
Pascal Belleau, Astrid Deschenes
}
\keyword{internal}
